/*!
 * @file glgui_widget.h
 * The gl_widget of the openglGUI
 */

#ifndef _GLGUI_WIDGET_H
#define _GLGUI_WIDGET_H

#include "element_2d.h"
#include "event.h"

#include "material.h"

#include "glincl.h"
#include "executor/executor.h"

// FORWARD DECLARATION
class Material;

typedef enum
{
  GLGuiSignal_click     = 0,
  GLGuiSignal_release,
  GLGuiSignal_rollOn,
  GLGuiSignal_rollOff,
  GLGuiSignal_open,
  GLGuiSignal_close,
  GLGuiSignal_destroy,

  GLGuiSignalCount,
} GLGuiSignalType;

//! if the Element should be visible by default.
#define GLGUI_WIDGET_DEFAULT_VISIBLE       false

//! This is widget part of the openglGUI class
/**
 * A widget is the main class of all the elements of th GUI.
 */
class GLGuiWidget : public Element2D {
  public:
    GLGuiWidget();
    virtual ~GLGuiWidget();

    void init();
    /** @returns a new char-array containing a string with the options. Delete with delete[]; */
    virtual char* save() {};
    /** loads options of the Widget. @param loadString a string containing the Options */
    virtual void load(const char* loadString) {};

    void show();
    void hide() {};

    void connectSignal(GLGuiSignalType signalType, const Executor& signal);
    void disconnectSignal(GLGuiSignalType signalType);
    bool focusOverWidget(float x, float y);

    // if something was clickt on the GUI-widget.
    virtual void click(const Event& event) {};
    virtual void release(const Event& event) {};

    virtual void receiveFocus() {};
    virtual void removeFocus() {};

    virtual void update() = 0;
    virtual void draw() const;

  protected:
    inline void startDraw() const { glPushMatrix(); glTranslatef(this->getAbsCoor2D().x, this->getAbsCoor2D().y, 0); };
    inline void endDraw() const { glPopMatrix(); };

  protected:
    Material              backMat;
    GLuint                backModel;

    Material              frontMat;
    GLuint                frontModel;

  private:
    Executor*             widgetSignals[GLGuiSignalCount];

    bool                  focusable;        //!< If this widget can receive focus.
    bool                  clickable;        //!< if this widget can be clicked upon.
};

#endif /* _GLGUI_WIDGET_H */
