/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_bar.h"

using namespace std;

/**
 * @brief standard constructor
*/
GLGuiBar::GLGuiBar ()
{
  this->init();

}


/**
 * @brief standard deconstructor
 */
GLGuiBar::~GLGuiBar()
{

}

/**
 * @brief initializes the GUI-element
 */
void GLGuiBar::init()
{
  this->setClassID(CL_GLGUI_BAR, "GLGuiBar");

  this->frontMat.setDiffuse(1,0,0);
  this->frontMat.setTransparency(.99);

  this->setSize2D(50, 10);

  this->value = 0.5f;
  this->minimum = 0.0f;
  this->maximum = 1.0f;
}

/**
 * @brief draws the GLGuiBar
 */
void GLGuiBar::draw() const
{
  this->startDraw();

  GLGuiWidget::draw();

  this->frontMat.select();
  glBegin(GL_QUADS);

  glVertex2f(.1 * this->getSizeX2D(), .1 * this->getSizeY2D());
  glVertex2f(.1 * this->getSizeX2D(), this->getSizeY2D()* .9 * (value/maximum));
  glVertex2f(this->getSizeX2D() * .9, this->getSizeY2D() * .9 * (value/maximum));
  glVertex2f(this->getSizeX2D() * .9, .1 * this->getSizeY2D());

  glEnd();
  this->endDraw();
}
