/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_bar.h"

using namespace std;

/**
 * standard constructor
*/
GLGuiBar::GLGuiBar ()
{
  this->init();

}


/**
 * standard deconstructor
*/
GLGuiBar::~GLGuiBar()
{

}

/**
 * initializes the GUI-element
 */
void GLGuiBar::init()
{
  this->setClassID(CL_GLGUI_BAR, "GLGuiBar");

  this->value = 0.5f;
  this->minimum = 0.0f;
  this->maximum = 1.0f;
}

/**
 * draws the GLGuiBar
 */
void GLGuiBar::draw() const
{

  printf("TEST %f %f\n", this->getAbsCoor2D().x, this->getAbsCoor2D().y);
  GLGuiWidget::draw();

  glBegin(GL_QUADS);

  glVertex2d(.1, .1);
  glVertex2d(.1, this->getSizeY2D()* .8 * (value/maximum));
  glVertex2d(this->getSizeX2D(), this->getSizeY2D() * .8 * (value/maximum));
  glVertex2d(this->getSizeX2D(), .1);

  glEnd();
}
