/*!
 * @file space_ship.h
 * Implements the Control of a Spaceship
 */

#ifndef _SPACE_SHIP_H
#define _SPACE_SHIP_H

#include "playable.h"


template<class T> class tList;
class Vector;
class Event;

class SpaceShip : public Playable
{

  public:

    SpaceShip();
    SpaceShip(const char* fileName);
    SpaceShip(const TiXmlElement* root);
    virtual ~SpaceShip();

    void init();
    void loadParams(const TiXmlElement* root);

    virtual void enter();
    virtual void leave();

    void addWeapon(Weapon* weapon );
    void removeWeapon(Weapon* weapon);

    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float time);
    virtual void draw() const;

    virtual void process(const Event &event);



  private:

    void calculateVelocity(float time);
    void weaponAction();

    // !! temporary !!
    void ADDWEAPON();

    bool                  bUp;                //!< up button pressed.
    bool                  bDown;              //!< down button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.
    bool                  bAscend;            //!< ascend button pressed.
    bool                  bDescend;           //!< descend button presses.
    bool                  bFire;              //!< fire button pressed.
    bool                  bRollL;             //!< rolling button pressed (left)
    bool                  bRollR;             //!< rolling button pressed (right)

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction
    float                 mouseSensitivity;   //!< the mouse sensitivity
    float                 cycle;              //!< hovercycle

    Vector                velocity;           //!< the velocity of the player.
    Quaternion            mouseDir;           //!< the direction where the player wants to fly
    Quaternion rotQuat;
    float                 travelSpeed;        //!< the current speed of the player (to make soft movement)
    float                 acceleration;       //!< the acceleration of the player.

    float                 airViscosity;

};

#endif /* _SPACE_SHIPS_H */
