

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "satellite.h"

#include "objModel.h"
#include "vector.h"


using namespace std;

/**
 *  standard constructor
*/
Satellite::Satellite (Vector axis, float speed)
{
  this->setClassID(CL_SATELLITE, "Satellite");

  this->loadModel("cube");
  this->speed = speed;
  this->axis = new Vector();
  *this->axis = axis;
}

/**
 *  standard destructor
*/
Satellite::~Satellite ()
{
}


/**
 *  this method is called every frame
 * @param time: the time in seconds that has passed since the last tick

   Handle all stuff that should update with time inside this method (movement, animation, etc.)
*/
void Satellite::tick(float time)
{
  float w = this->speed * M_PI;

  Quaternion rotation(w * time, *this->axis);
  Quaternion v = this->getRelDir();

  this->setRelDir(v * rotation);
}

