/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "weapon_power_up.h"
#include "factory.h"
#include "state.h"

#include "primitive_model.h"

#include "factory.h"
#include "load_param.h"

using namespace std;

CREATE_FACTORY(WeaponPowerUp, CL_WEAPON_POWER_UP);

WeaponPowerUp::WeaponPowerUp () : PowerUp(1.0, 1.0, 0.0)
{
  this->init();
}

WeaponPowerUp::WeaponPowerUp(const TiXmlElement* root) : PowerUp(1.0, 1.0, 0.0)
{
  this->init();
  this->loadParams(root);
}


WeaponPowerUp::~WeaponPowerUp ()
{
}


void WeaponPowerUp::init()
{
  weaponXML = NULL;
  weapon = NULL;
}


void WeaponPowerUp::loadParams(const TiXmlElement* root)
{
  static_cast<PowerUp*>(this)->loadParams(root);
  const TiXmlElement* elem = root->FirstChildElement("weapon");
  if(elem != NULL && (elem = elem->FirstChildElement()) != NULL)
  {
    this->weaponXML = elem;
    respawn();
  }
  else
  {
    LoadParam(root, "weaponID", this, WeaponPowerUp, setWeaponClass);
  }
}

Weapon* WeaponPowerUp::getWeapon()
{
  return this->weapon;
}

void WeaponPowerUp::respawn()
{
  this->weapon = dynamic_cast<Weapon*>((weaponXML == NULL)
      ? Factory::fabricate(static_cast<ClassID>(this->weapon->getClassID()))
      : Factory::fabricate(weaponXML));
}

void WeaponPowerUp::setWeaponClass(const char* name)
{
  this->weapon = dynamic_cast<Weapon*>(Factory::fabricate(name));
}
