/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "param_power_up.h"
#include "factory.h"
#include "state.h"

#include "primitive_model.h"

#include "factory.h"
#include "load_param.h"

using namespace std;

CREATE_FACTORY(ParamPowerUp, CL_PARAM_POWER_UP);

const char* ParamPowerUp::paramTypes[] = {
  "shield"
};

ParamPowerUp::ParamPowerUp () : PowerUp(0.0, 1.0, 0.0)
{
  this->init();
}

ParamPowerUp::ParamPowerUp(const TiXmlElement* root) : PowerUp(0.0, 1.0, 0.0)
{
  this->init();
  this->loadParams(root);
}


ParamPowerUp::~ParamPowerUp ()
{
}


void ParamPowerUp::init()
{
  this->value = 0;
  this->max_value = 0;
  this->min_value = 0;
}


void ParamPowerUp::loadParams(const TiXmlElement* root)
{
  static_cast<PowerUp*>(this)->loadParams(root);
  LoadParam(root, "type", this, ParamPowerUp, setType);
  if(root->FirstChildElement("value") != NULL) {
    LoadParam(root, "value", this, ParamPowerUp, setValue);
  }
  else {
    LoadParam(root, "max-value", this, ParamPowerUp, setMaxValue);
    LoadParam(root, "min-value", this, ParamPowerUp, setMinValue);
    respawn();
  }
}

void ParamPowerUp::setValue(int value)
{
  this->value = value;
}

void ParamPowerUp::setType(const char* type)
{
  for(int i = 0; i < PARAM_size; ++i) {
    if(strcmp(type, paramTypes[i]) == 0) {
      this->type = (EnumParamPowerUpType)i;
      break;
    }
  }
}

void ParamPowerUp::setMaxValue(int value)
{
  this->max_value = value;
}

void ParamPowerUp::setMinValue(int value)
{
  this->min_value = value;
}

int ParamPowerUp::getValue()
{
  return this->value;
}

EnumParamPowerUpType ParamPowerUp::getType()
{
  return this->type;
}

void ParamPowerUp::respawn()
{
  if(this->min_value != this->max_value)
  {
    value = this->min_value + (int)(rand() * (this->max_value - this->min_value));
  }
}


