/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Knecht
*/

#include "player.h"
#include "playable.h"

#include "event_handler.h"


#include "class_list.h"
#include "state.h"

using namespace std;


/**
 * creates a new Player
*/
Player::Player()
{
  this->init();

  EventHandler::getInstance()->subscribe(this, ES_GAME, SDLK_l);
}


/**
 *  destructs the player, deletes alocated memory
 */
Player::~Player ()
{
}


/**
 * initializes a Player
 */
void Player::init()
{
//  this->setRelDir(Quaternion(M_PI, Vector(1,0,0)));
  this->setClassID(CL_PLAYER, "Player");

  PRINTF(4)("PLAYER INIT\n");

  this->controllable = NULL;
}


bool Player::setControllable(Playable* controllable)
{
  if(controllable != NULL && controllable->subscribePlayer(this))
  {
      this->controllable = controllable;
      return true;
  }
  else
    return false;
}

bool Player::disconnectControllable()
 {
   if(this->controllable == NULL) return true;

   if(this->controllable->unsubscribePlayer(this))
   {
     this->controllable = NULL;
     return true;
   }
   else
     return false;
 }

 void Player::process(const Event &event)
 {
   if (event.type == SDLK_l && event.bPressed)
   {
     /// FIXME this should be in the ObjectManager
     const std::list<BaseObject*>* objectList = ClassList::getList(CL_PLAYABLE);
     if (objectList != NULL)
     {
       list<BaseObject*>::const_iterator node;
       for (node = objectList->begin(); node != objectList->end(); node++)
         if (this->controllable != (*node) && (dynamic_cast<PNode*>(*node)->getAbsCoor() - this->controllable->getAbsCoor()).len() < 10.0)
       {
         this->controllable->leave();
         this->disconnectControllable();
         this->setControllable(dynamic_cast<Playable*>(*node));
         this->controllable->enter();
         State::getCamera()->setParentSoft(this->controllable);
         State::getCameraTarget()->setParentSoft(this->controllable);

         break;
       }
     }
   }

   if (likely(this->controllable != NULL))
     this->controllable->process(event);
 }

