
/*!
 * @file playable.h
 * Interface for a basic controllable WorldEntity
 */
#ifndef _PLAYABLE_H
#define _PLAYABLE_H

#include "world_entity.h"
#include "event.h"
#include <list>

class Weapon;
class WeaponManager;
class Player;

//! Basic controllable WorldEntity
/**
 *
 */
class Playable : public WorldEntity
{
  public:
    Playable();
    virtual ~Playable();

    virtual void enter() {};
    virtual void leave() {};

    virtual void addWeapon(Weapon* weapon )  {}//= 0;
    virtual void removeWeapon(Weapon* weapon) {}//= 0;
    inline WeaponManager* getWeaponManager() const { return this->weaponMan; };

    bool subscribePlayer(Player* player);
    bool unsubscribePlayer(Player* player);

    virtual void process(const Event &event) = 0;



    /** @return a List of Events in PEV_* sytle */
    inline const std::list<int>& getEventList() { return this->events; };

  protected:
    void registerEvent(int eventType);
    void unregisterEvent(int eventType);

  private:
    void init();

  private:
    WeaponManager*        weaponMan;          //!< the weapon manager: managing a list of weapon to wepaon-slot mapping
    std::list<int>        events;             //!< A list of Events, that are captured for this playable

    Player*               currentPlayer;      //!< The Player currently connected to this Playable (the one that has controll) otherwise NULL

};

#endif /* _PLAYABLE_H */
