/*!
 * @file md2_creature.h
 * Implements the control of a md2 model
 */

#ifndef _MD2_CREATURE_H
#define _MD2_CREATURE_H

#include "playable.h"


template<class T> class tList;
class Vector;
class Event;

class MD2Creature : public Playable
{

  public:

    MD2Creature();
    MD2Creature(const char* fileName);
    MD2Creature(const TiXmlElement* root);
    virtual ~MD2Creature();

    void init();
    void loadParams(const TiXmlElement* root);

    virtual void enter();
    virtual void leave();

    void addWeapon(Weapon* weapon );
    void removeWeapon(Weapon* weapon);

    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float time);
    virtual void draw() const;

    virtual void process(const Event &event);



  private:

    void calculateVelocity(float time);
    void weaponAction();

    // !! temporary !!
    void ADDWEAPON();

    bool                  bUp;                //!< up button pressed.
    bool                  bDown;              //!< down button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.
    bool                  bAscend;            //!< ascend button pressed.
    bool                  bDescend;           //!< descend button presses.
    bool                  bFire;              //!< fire button pressed.
    bool                  bRollL;             //!< rolling button pressed (left)
    bool                  bRollR;             //!< rolling button pressed (right)
    bool                  bStrafeL;           //!< strafe to the left side
    bool                  bStrafeR;           //!< strafe to the rith side
    bool                  bJump;              //!< jump

    PNode                 cameraConnNode;     //!< The Node the camera is connected to.

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction
    float                 mouseSensitivity;   //!< the mouse sensitivity
    float                 cycle;              //!< hovercycle

    Vector                velocity;           //!< the velocity of the player.
    Quaternion            mouseDirX;           //!< the direction where the player wants to fly
    Quaternion            mouseDirY;           //!< the direction where the player wants to fly
    float                 travelSpeed;        //!< the current speed of the player (to make soft movement)
    float                 acceleration;       //!< the acceleration of the player.

    float                 airViscosity;

};

#endif /* _MD2_CREATURE_H */
