/*!
 * @file state.h
 * Definition of the States Class
*/

#ifndef _STATE_H
#define _STATE_H

// FORWARD DECLARATION
class PNode;
class WorldEntity;
class ObjectManager;

//! handles states about orxonox's most importatn objects
/**
 * This is an abstract Class-container, not really a Class.
 * in this Class only static references to the most important
 * Objects/List/etc. are stored.
 */
class State {

 public:
   //////////////
   /// CAMERA ///
   //////////////
  /** @param camera the PNode to the Camera, @param cameraTarget the PNode to the Camera's target */
  static void setCamera(PNode* camera, PNode* cameraTarget);
  /** @returns a Pointer to the PNode of the Camera */
  static inline PNode* getCamera() { return State::camera; };
  /** @returns a Pointer to the CameraTarget */
  static inline PNode* getCameraTarget() { return State::cameraTarget; };

  //////////////////////
  /// OBJECT-MANAGER ///
  //////////////////////
  /** @param objectManager the new Current ObjectManager */
  static inline void setObjectManager(ObjectManager* objectManager) { State::objectManager = objectManager; };
  /** @returns the current ObjectManager. */
  static inline ObjectManager* getObjectManager() { return State::objectManager; };

  /////////////////////////
  /// WORLD_ENTITY_LIST ///
  /////////////////////////

 private:
  State();

  static PNode*                 camera;             //!< A reference to the camera
  static PNode*                 cameraTarget;       //!< A reference to the cameraTarget
  static PNode*                 nullParent;         //!< A reference to the Null-PNode.
  static ObjectManager*         objectManager;      //!< A referenct to the current ObjectManager

};

#endif /* _STATE_H */
