/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...

   this file extends the framework file, so it renders what i want.
*/

#include "framework.h"

#include "light.h"

#include "objModel.h"
#include "md2Model.h"
#include "primitive_model.h"
#include <stdlib.h>

#include "resource_manager.h"

Model* obj;

void Framework::moduleInit(int argc, char** argv)
{
  ResourceManager::getInstance()->addImageDir("./");

  for (int i = 0; i < argc; i++)
  {
    printf("%s\n", argv[i]);
  }
  ResourceManager::getInstance()->addImageDir("");


  if (argc>=3)
  {
    if( strstr(argv[1], ".obj") != NULL)
      obj = new OBJModel (argv[1], atof(argv[2]));
    else if( strstr(argv[1], ".md2") != NULL)
    {
      obj = new MD2Model(argv[1], argv[2]);
      ((MD2Model*)obj)->tick(0.1f);
    }
  }
  else if (argc>=2)
  {
    if( strstr(argv[1], ".obj") != NULL)
      obj = new OBJModel(argv[1]);
    else if( strstr(argv[1], ".md2") != NULL) {
      obj = new MD2Model(argv[1], "fake_texture.bad");
      obj = new MD2Model(argv[1], argv[2]);
      ((MD2Model*)obj)->tick(0.1f);
    }
  }
  else
    obj = new PrimitiveModel(PRIM_CYLINDER);

  ResourceManager::getInstance()->debug();

  LightManager* lightMan = LightManager::getInstance();
  lightMan->setAmbientColor(.1,.1,.1);
  (new Light())->setAbsCoor(5.0, 10.0, 40.0);
  (new Light())->setAbsCoor(-10, -20, -100);
}

void Framework::moduleEventHandler(SDL_Event* event)
{
  switch (event->type)
    {
    case SDL_KEYDOWN:
      switch (event->key.keysym.sym)
        {
        case SDLK_i:
          break;
        }
    }
}

void Framework::moduleTick(float dt)
{

}

void Framework::moduleDraw(void) const
{
  obj->draw();

  LightManager::getInstance()->draw();
}


void Framework::moduleHelp(void) const
{

}
