/*!
 * @file converter.h
 *  Is able to convert int to byte-array and vice versa
 */

#ifndef _CONVERTER
#define _CONVERTER

/* include this file, it contains some default definitions */
#include "netdefs.h"

/* include base_object.h since all classes are derived from this one */
#include "base_object.h"

/* The size of an int in byte */
#define INTSIZE 4

/*!
 * a class that can convert int to byte-array and vice versa
 */
class Converter: public BaseObject
{
  public:
    static byte* intToByteArray(int x);
    static int byteArrayToInt(const byte* a);

    //byte* floatToByteArray(float x);
    //float byteArrayToFloat(byte[] a);

    //Test
    static char* floatToBinString(float x);

    static byte* floatToByteArray(float x);
    static float byteArrayToFloat(byte* a);

    static byte* _floatToByteArray(float x);
    static float _byteArrayToFloat(byte* a);
  private:
    Converter();
    ~Converter();
};

#endif /*_CONVERTER*/
