/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.


### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Wuest
*/

#define DEBUG_MODULE_NETWORK

#include "synchronizeable.h"
#include "netdefs.h"
#include "network_manager.h"
#include "network_stream.h"


/**
 *  default constructor
 */
Synchronizeable::Synchronizeable()
{

  owner = 0;
  hostID = NetworkManager::getInstance()->getHostID();
  uniqueID = -1;
  this->networkStream = NULL;
  //state = ?;

}

/**
 *  default constructor
 */
Synchronizeable::Synchronizeable(const char* name)
{
  this->setName(name);
  this->networkStream = NULL;
}


/**
 *  default destructor deletes all unneded stuff
 */
Synchronizeable::~Synchronizeable()
{
  if ( this->networkStream )
    this->networkStream->disconnectSynchronizeable(*this);
}

/**
 *  write data to NetworkStream
 */
void Synchronizeable::writeBytes(const byte* data, int length)
{
  PRINTF(1)("Synchronizeable::writeBytes was called\n");
}

/**
 *  read data from NetworkStream
 */
int Synchronizeable::readBytes(byte* data, int maxLength, int * reciever)
{
  PRINTF(1)("Synchronizeable::readBytes was called\n");
}


void Synchronizeable::writeDebug() const
{}


void Synchronizeable::readDebug() const
{}


/**
 * Sets the server flag to a given value
 * @param isServer: the boolean value which the server flag is to set to
 */
void Synchronizeable::setIsServer(bool isServer)
{
  if( isServer )
    this->state = this->state | STATE_SERVER;
  else
    this->state = this->state & (~STATE_SERVER);
}

/**
 * Sets the outofsync flag to a given value
 * @param outOfSync: the boolean value which the outofsync flag is to set to
 */
void Synchronizeable::setIsOutOfSync(bool outOfSync)
{
  if( outOfSync )
    this->state = this->state | STATE_OUTOFSYNC;
  else
    this->state = this->state & (~STATE_OUTOFSYNC);
}

/**
 * Determines if the server flag is set
 * @return true, if the server flag is true, false else
 */
bool Synchronizeable::isServer()
{
  return this->state & STATE_SERVER == STATE_SERVER;
}

/**
 * Determines if the outofsync flag is set
 * @return true, if the outofsync flag is true, false else
 */
bool Synchronizeable::isOutOfSync()
{
  return this->state & STATE_OUTOFSYNC == STATE_OUTOFSYNC;
}



