/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: claudio
   co-programmer:
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK


#include "base_object.h"
#include "network_protocol.h"
#include "network_socket.h"
#include "connection_monitor.h"
#include "synchronizeable.h"
#include "network_manager.h"
#include "debug.h"
#include "class_list.h"
#include <algorithm>

/* include your own header */
#include "network_stream.h"

/* probably unnecessary */
using namespace std;


#define PACKAGE_SIZE  256


NetworkStream::NetworkStream()
    : DataStream()
{
  this->init();
  /* initialize the references */
  this->type = NET_CLIENT;
  this->networkProtocol = new NetworkProtocol();
  this->connectionMonitor = new ConnectionMonitor();
}

NetworkStream::NetworkStream(IPaddress& address)
{
  this->type = NET_CLIENT;
  this->init();
  this->networkSockets.push_back(new NetworkSocket(address));
  this->networkProtocol = new NetworkProtocol();
  this->connectionMonitor = new ConnectionMonitor();

  Handshake* hs = new Handshake(false);
  hs->setUniqueID( 0 );
  this->handshakes.push_back(hs);
  this->connectSynchronizeable(*hs);
  PRINTF(0)("NetworkStream: %s\n", hs->getName());
}


NetworkStream::NetworkStream(unsigned int port)
{
  this->type = NET_SERVER;
  this->init();
  this->serverSocket = new ServerSocket(port);
  this->networkProtocol = new NetworkProtocol();
  this->connectionMonitor = new ConnectionMonitor();
  this->networkSockets.push_back( NULL );
  this->handshakes.push_back( NULL );
  this->bActive = true;

  this->setMaxConnections( 10 );
}


void NetworkStream::init()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_STREAM, "NetworkStream");
  this->bActive = false;
  this->serverSocket = NULL;
  myHostId = 0;
}


NetworkStream::~NetworkStream()
{
  if ( this->serverSocket )
  {
    serverSocket->close();
    delete serverSocket;
  }

  for (NetworkSocketVector::iterator i = networkSockets.begin(); i!=networkSockets.end(); i++)
  {
    if ( *i )
    {
      (*i)->disconnectServer();
      (*i)->destroy();
    }
  }

  for (HandshakeVector::iterator i = handshakes.begin(); i!=handshakes.end(); i++)
  {
    if ( *i )
    {
      delete (*i);
    }
  }

  delete connectionMonitor;
  delete networkProtocol;
}


void NetworkStream::connectSynchronizeable(Synchronizeable& sync)
{
  this->synchronizeables.push_back(&sync);
  sync.setNetworkStream( this );

  if( this->networkSockets.size()>0 )
    this->bActive = true;
}

void NetworkStream::disconnectSynchronizeable(Synchronizeable& sync)
{
  // removing the Synchronizeable from the List.
  std::list<Synchronizeable*>::iterator disconnectSynchro = std::find(this->synchronizeables.begin(), this->synchronizeables.end(), &sync);
  if (disconnectSynchro != this->synchronizeables.end())
    this->synchronizeables.erase(disconnectSynchro);

  if( this->networkSockets.size()<=0 )
    this->bActive = false;
}


void NetworkStream::processData()
{
  if ( this->type == NET_SERVER )
    this->updateConnectionList();
  else
  {
    if ( networkSockets[0] && !networkSockets[0]->isOk() )
    {
      PRINTF(1)("lost connection to server\n");

      //delete networkSockets[i];
      networkSockets[0]->disconnectServer();
      networkSockets[0]->destroy();
      networkSockets[0] = NULL;
      //TODO: delete handshake from synchronizeable list so i can delete it
      if ( handshakes[0] )
        delete handshakes[0];
      handshakes[0] = NULL;
    }
  }

  for (int i = 0; i<handshakes.size(); i++)
  {
    if ( handshakes[i] )
    {
      if ( handshakes[i]->completed() )
      {
        if ( handshakes[i]->ok() )
        {
          if ( type != NET_SERVER )
          {
            NetworkManager::getInstance()->setHostID( handshakes[i]->getHostId() );
            myHostId = NetworkManager::getInstance()->getHostID();
          }
          PRINT(0)("handshake finished\n");
          delete handshakes[i];
          handshakes[i] = NULL;
          //TODO: replace handshake by entitymanager
        }
        else
        {
          PRINT(1)("handshake failed!\n");
          networkSockets[i]->disconnectServer();
          delete handshakes[i];
          handshakes[i] = NULL;
          //TODO: handle error
        }
      }
    }
  }


  /* DOWNSTREAM */

  int dataLength;
  int reciever;
  Header header;
  for (SynchronizeableList::iterator it = synchronizeables.begin(); it!=synchronizeables.end(); it++)
  {
    //TODO: remove items from synchronizeables if they dont exist
    if ( (*it)!=NULL && (*it)->getOwner() == myHostId )
    {
      do {
        reciever = 0;
        dataLength = (*it)->readBytes(downBuffer, DATA_STREAM_BUFFER_SIZE, &reciever);


        if ( dataLength<=0 ){
          reciever = 0;
          continue;
        }

        dataLength = networkProtocol->createHeader((byte*)downBuffer, dataLength, DATA_STREAM_BUFFER_SIZE, static_cast<const Synchronizeable&>(*(*it)));

        //FIXME: this is a hack, find a better way
        Header* header = (Header*)downBuffer;
        if ( header->synchronizeableID<100 )
          header->synchronizeableID = 0;

        if ( dataLength<=0 )
          continue;

        if ( reciever!=0 )
        {
          if ( networkSockets[reciever] != NULL )
          {
            PRINTF(5)("write %d bytes to socket %d\n", dataLength, reciever);
            networkSockets[reciever]->writePacket(downBuffer, dataLength);
          }
          else
          {
            PRINTF(1)("networkSockets[reciever] == NULL\n");
          }
        }
        else
        {
          for ( int i = 0; i<networkSockets.size(); i++)
          {
            if ( networkSockets[i] != NULL )
            {
              PRINTF(5)("write %d bytes to socket %d\n", dataLength, reciever);
              networkSockets[i]->writePacket(downBuffer, dataLength);
            }
          }
        }

      } while( reciever!=0 );
    }
    else
    {
      PRINTF(0)("synchronizeables == NULL");
    }
  }

  /* UPSTREAM */

  for ( int i = 0; i<networkSockets.size(); i++)
  {
    if ( networkSockets[i] )
    {
      do {
        dataLength = networkSockets[i]->readPacket(upBuffer, DATA_STREAM_BUFFER_SIZE);

        if ( dataLength<=0 )
          continue;

        PRINTF(5)("read %d bytes from socket\n", dataLength);
        header = networkProtocol->extractHeader(upBuffer, dataLength);
        dataLength -= sizeof(header);

        if ( dataLength != header.length )
        {
          PRINTF(1)("packetsize in header and real packetsize do not match! %d:%d\n", dataLength, header.length);
          continue;
        }

        if ( header.synchronizeableID == 0 )
        {
          header.synchronizeableID = i;
        }

        for (SynchronizeableList::iterator it = synchronizeables.begin(); it!=synchronizeables.end(); it++)
        {
          if ( *it && (*it)->getUniqueID()==header.synchronizeableID )
            (*it)->writeBytes(upBuffer+sizeof(header), dataLength);
        }

      } while ( dataLength>0 );
    }
  }
}

void NetworkStream::updateConnectionList( )
{
  //check for new connections

  NetworkSocket* tempNetworkSocket = serverSocket->getNewSocket();

  if ( tempNetworkSocket )
  {
    int clientId;
    if ( freeSocketSlots.size() >0 )
    {
      clientId = freeSocketSlots.back();
      freeSocketSlots.pop_back();
      networkSockets[clientId] = tempNetworkSocket;
      handshakes[clientId] = new Handshake(true, clientId);
      handshakes[clientId]->setUniqueID(clientId);
    } else
    {
      clientId = networkSockets.size();
      networkSockets.push_back(tempNetworkSocket);
      Handshake* tHs = new Handshake(true, clientId);
      tHs->setUniqueID(clientId);
      handshakes.push_back(tHs);
    }

    if ( clientId > this->maxConnections )
    {
      handshakes[clientId]->doReject();
      PRINTF(0)("Will reject client %d because there are to many connections!\n", clientId);
    }
    else

    PRINTF(0)("New Client: %d\n", clientId);

    this->connectSynchronizeable(*handshakes[clientId]);
  }


  //check if connections are ok else remove them
  for ( int i = 1; i<networkSockets.size(); i++)
  {
    if ( networkSockets[i] && !networkSockets[i]->isOk() )
    {
      //TODO: tell EntityManager that this player left the game
      PRINTF(0)("Client is gone: %d\n", i);

      //delete networkSockets[i];
      networkSockets[i]->disconnectServer();
      networkSockets[i]->destroy();
      networkSockets[i] = NULL;
      //TODO: delete handshake from synchronizeable list so i can delete it
      if ( handshakes[i] )
        delete handshakes[i];
      handshakes[i] = NULL;

      if ( i == networkSockets.size()-1 )
      {
        networkSockets.pop_back();
        handshakes.pop_back();
      }
      else
      {
        freeSocketSlots.push_back(i);
      }
    }
  }


}

void NetworkStream::setMaxConnections( int n )
{
  if ( !this->isServer() )
  {
    PRINTF(1)("Cannot set maxConnections because I am no server.\n");
  }
  if ( this->networkSockets.size() > 1 )
  {
    PRINTF(1)("Cannot set maxConnections because there are already %d connections.\n", this->networkSockets.size());
    return;
  }
  this->maxConnections = n;
}


