/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_SOUND

#include "sound_source.h"
#include "sound_engine.h"

#include "alincl.h"
#include "compiler.h"

using namespace std;

/**
 *  creates a SoundSource at position sourceNode with the SoundBuffer buffer
 */
SoundSource::SoundSource(const PNode* sourceNode, const SoundBuffer* buffer)
{
  this->setClassID(CL_SOUND_SOURCE, "SoundSource");

  ALenum result;

  // adding the Source to the SourcesList of the SoundEngine
  this->buffer = buffer;
  this->sourceNode = sourceNode;

  this->sourceID = 0;
  this->bPlay = false;
}

/**
 *  deletes a SoundSource
 */
SoundSource::~SoundSource()
{
  SoundEngine::getInstance()->pushALSource(this->sourceID);
}

/**
 *  Plays back a SoundSource
 */
void SoundSource::play()
{
  if (this->sourceID == 0)
    SoundEngine::getInstance()->popALSource(this->sourceID);
  alSourcePlay(this->sourceID);
  this->bPlay = true;
}

/**
 * Plays back buffer on this Source
 * @param buffer the buffer to play back on this Source
 */
void SoundSource::play(const SoundBuffer* buffer)
{
  if (unlikely(this->sourceID == 0))
    SoundEngine::getInstance()->popALSource(this->sourceID);

  alSourceStop(this->sourceID);
  alSourcei (this->sourceID, AL_BUFFER, buffer->getID());
  alSourcePlay(this->sourceID);

  if (unlikely(this->buffer != NULL))
    alSourcei (this->sourceID, AL_BUFFER, this->buffer->getID());
  this->bPlay = true;
}

/**
 *  Stops playback of a SoundSource
 */
void SoundSource::stop()
{
  this->bPlay = false;
  alSourceStop(this->sourceID);
  SoundEngine::getInstance()->pushALSource(this->sourceID);
}

/**
 *  Pauses Playback of a SoundSource
 */
void SoundSource::pause()
{
  alSourcePause(this->sourceID);
}

/**
 *  Rewinds Playback of a SoundSource
 */
void SoundSource::rewind()
{
  alSourceRewind(this->sourceID);
}

/**
 *  sets the RolloffFactor of the Sound emitted from the SoundSource
 * @param rolloffFactor The Factor described

   this tells openAL how fast the Sounds decay outward from the Source
 */
void SoundSource::setRolloffFactor(ALfloat rolloffFactor)
{
  alSourcef(this->sourceID, AL_ROLLOFF_FACTOR, rolloffFactor);
}

