/*!
 * @file cd_engine.h
  *  Definition of the collision detection engine

*/

#ifndef _CD_ENGINE_H
#define _CD_ENGINE_H

#include "base_object.h"
#include "collision_defs.h"
#include "model.h"

#include <list>

class WorldEntity;
class OBBTree;
class Terrain;
//class Player;


//! featured state options, they are all additive
typedef enum cdState
  {
    CD_DEBUG_DRAW_ALL = 1,
    CD_DEBUG_DRAW_POLYGONS = 1<<1,
    CD_DEBUG_DRAW_BLENDED = 1<<2,
    CD_DEBUG_DRAW_HIT_BV = 1<<3,
    CD_DEBUG_VERBOSE = 1<<4,

    CD_STORE_VERTICES = 1<<5
  };


//! The class representing the collision detection system of orxonox
class CDEngine : public BaseObject {

  friend class WorldEntity;

 public:
  virtual ~CDEngine();
  /** @returns a Pointer to the only object of this Class */
  static CDEngine* getInstance() { if (!singletonRef) singletonRef = new CDEngine(); return singletonRef; }
  void init();

  inline void setState(const int newState) { this->state = newState; }
  inline const int getState() const { return this->state; }
  inline void enable(const int options) { this->state |= options; }
  inline void disable(const int options) { int temp = this->state & options; this->state ^= temp; }

  inline void setTerrain(Terrain* terrain) { this->terrain = terrain; }
  //  inline void setPlayer(Player* player) { this->player = player; } /* only for debug purposes \todo: delete*/

  void drawBV(int depth, int drawMode) const;

//  void checkCollisions();
  void checkCollisions(std::list<WorldEntity*>& list1, std::list<WorldEntity*>& list2);

  void debug();


 private:
  CDEngine();
  static CDEngine* singletonRef;

  void spawnBVTree(int depth = MAX_BV_TREE_DEPTH);

  void checkCollisionObjects();
  void checkCollisionGround();

  void debugSpawnTree(int depth, sVec3D* vertices, int numVertices);
  void debugDraw(int depth, int drawMode);


 private:
  int                     state;                            //!< the current state of the cd engine
  OBBTree*                rootTree;                         //!< for testing purposes a root tree

  Terrain*                terrain;                          //!< this it a ref to the terrain, serving as a ground for all WE
//  Player*                 player;
};

#endif /* _CD_ENGINE_H */
