/*!
 * @file object_manager.h
 * @brief Definition of the ... singleton Class
*/

#ifndef _OBJECT_MANAGER_H
#define _OBJECT_MANAGER_H

#include "base_object.h"
#include <list>
#include <vector>

/// Enumerator for Managed Object Lists
typedef enum {
  OM_NULL             =  0,
  OM_DEAD,
  OM_ENVIRON_NOTICK,
  OM_ENVIRON,
  OM_COMMON,

  OM_GROUP_00,
  OM_GROUP_00_PROJ,
  OM_GROUP_01,
  OM_GROUP_01_PROJ,
  OM_GROUP_02,
  OM_GROUP_02_PROJ,
  OM_GROUP_03,
  OM_GROUP_03_PROJ,
  OM_GROUP_04,
  OM_GROUP_04_PROJ,
  OM_GROUP_05,
  OM_GROUP_05_PROJ,
  OM_GROUP_06,
  OM_GROUP_06_PROJ,
  OM_GROUP_07,
  OM_GROUP_07_PROJ,
  OM_GROUP_08,
  OM_GROUP_08_PROJ,
  OM_GROUP_09,
  OM_GROUP_09_PROJ,
  OM_GROUP_10,
  OM_GROUP_10_PROJ,
  OM_GROUP_11,
  OM_GROUP_11_PROJ,
  OM_GROUP_12,
  OM_GROUP_12_PROJ,
  OM_GROUP_13,
  OM_GROUP_13_PROJ,
  OM_GROUP_14,
  OM_GROUP_14_PROJ,
  OM_GROUP_15,
  OM_GROUP_15_PROJ,

  OM_SIZE,


  OM_INIT             = -1, //!< DO NOT USE THIS. (WorldEntity Internal).
} OM_LIST;

#define OM_DEFAULT_LIST  OM_NULL


// FORWARD DECLARATION
class PNode;
class WorldEntity;

//! A default singleton class.
class ObjectManager : public BaseObject {

 public:
  virtual ~ObjectManager(void);
  /** @returns a Pointer to the only object of this Class */
  inline static ObjectManager* getInstance(void) { if (!ObjectManager::singletonRef) ObjectManager::singletonRef = new ObjectManager();  return ObjectManager::singletonRef; }


  void toList (WorldEntity* entity, OM_LIST omList = OM_DEFAULT_LIST);
  void toList (WorldEntity* entity, const char* omList);


  std::list<WorldEntity*>& getObjectList(OM_LIST listNumber) { return this->objectLists[listNumber]; }
  const std::list<WorldEntity*>& getObjectList(OM_LIST listNumber) const { return this->objectLists[listNumber]; }

  static std::list<WorldEntity*>* distanceFromObject(const PNode& center, float radius, ClassID classID);

  void debug(OM_LIST omList) const;
  void debug(const char* listName = NULL);

  static OM_LIST StringToOMList(const char* listName);
  static const char* OMListToString(OM_LIST omList);

 private:
  ObjectManager(void);
  static ObjectManager* singletonRef;

  const std::list<BaseObject>*            pNodeList;


  std::list<WorldEntity*>                 objectLists[OM_SIZE];

  static const char*                      objectManagerListNames[]; //!< Names of all the lists
};

#endif /* _OBJECT_MANAGER_H */
