/*!
 * @file entity_manager.h
 *  Manages creation and destruction of entities
 */

#ifndef _NETWORK_GAME_MANGER
#define _NETWORK_GAME_MANAGER

/* include this file, it contains some default definitions */
#include "netdefs.h"

/* include base_object.h since all classes are derived from this one */
#include "synchronizeable.h"



/**
 * protocol definition
 *
 *  CREATE_ENTITY:      CLASS_ID, UNIQUE_ID, OWNER
 *  REMOVE_ENTITY:      UNIQUE_ID
 *
 *  CREATE_ENTITY_LIST: NUMBER, [CLASS_ID, UNIQUE_ID, OWNER][0..NUMBER]
 *  REMOVE_ENTITY_LIST: NUMBER, [UNIQUE_ID][0..NUMBER]
 *
 *  REQUEST_CREATE:     CLASS_ID
 *  REQUEST_REMOVE:     UNIQUE_ID
 *
 *  REQUEST_SYNC:       UNIQUE_ID
 *  REQUEST_SYNC_LIST:  NUMBER, [UNIQUE_ID][0..NUMBER]
 *
 *
 */










/*!
 * a class that can create and remove entities
 */
class NetworkGameManager: public Synchronizeable
{
  public:
    NetworkGameManager();
    ~NetworkGameManager();

    virtual void writeBytes(const byte* data, int length);
    virtual int readBytes(byte* data, int maxLength, int * reciever);
    virtual void writeDebug() const;
    virtual void readDebug() const;

    void createEntity(int classID);
    void createEntityList(int* classIDList);
    void removeEntity(int uniqueID);
    void removeEntityList(int* uniqueIDList);

    void sync(int uniqueID);
    void syncList(int* uniqueIDList);


  private:
    void requestCreateEntity(int classID);
    void executeCreateEntity(int classID);
    void requestCreateEntityList(int* classIDList);
    void executeCreateEntityList(int* classIDList);

    void requestRemoveEntity(int uniqueID);
    void executeRemoveEntity(int uniqueID);
    void requestRemoveEntityList(int* uniqueIDList);
    void executeRemoveEntityList(int* uniqueIDList);



    bool canCreateEntity(int classID);



  private:
    byte*          inBuffer;
    byte*          outBuffer;
};

#endif /*_ENTITY_MANGER*/
