/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Wuest
   co-programmer: ...
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

/* include your own header */
#include "network_game_manager.h"


/* using namespace std is default, this needs to be here */
using namespace std;

/*!
 * Standard constructor
 */
NetworkGameManager::NetworkGameManager()
{
  /* set the class id for the base object */
  this->setClassID(CL_ENTITY_MANAGER, "EntityManager");
}

/*!
 * Standard destructor
 */
NetworkGameManager::~NetworkGameManager()
{
}


void NetworkGameManager::writeBytes(const byte* data, int length)
{
}

int NetworkGameManager::readBytes(byte* data, int maxLength, int * reciever)
{
}

void NetworkGameManager::writeDebug() const
{
}

void NetworkGameManager::readDebug() const
{
}


/*!
 * Checks whether this is connected to a server or a client
 * and afterwards creates the needed entity if possible
 * @param classID: The ID of the class of which an entity should be created
 */
void NetworkGameManager::createEntity(int classID)
{
}

/*!
 * Checks whether this is connected to a server or a client
 * and afterwards removes the specified entity
 * @param uniqueID: The ID of the entity object which should be removed
 */
void NetworkGameManager::removeEntity(int uniqueID)
{
}



/*!
 * Creates the needed entity on the server if possible
 * @param classID: The ID of the class of which an entity should be created
 */
void NetworkGameManager::requestCreateEntity(int classID)
{
}

/*!
 * Removes the specified entity on the server
 * @param uniqueID: The ID of the entity object which should be removed
 */
void NetworkGameManager::requestRemoveEntity(int uniqueID)
{
}

/*!
 * Creates the needed entity if possible
 * This function is called if this is a server
 * @param classID: The ID of the class of which an entity should be created
 */
void NetworkGameManager::executeCreateEntity(int classID)
{
}

/*!
 * Removes the specified entity
 * This function is called if this is a server
 * @param uniqueID: The ID of the entity object which should be removed
 */
void NetworkGameManager::executeRemoveEntity(int uniqueID)
{
}

/*!
 * Checks whether it is possible to create an entity of a given class
 * @return: true if the entity can be created, false otherwise
 */
bool NetworkGameManager::canCreateEntity(int classID)
{
}
