/*!
 * @file network_stream.h
 *  implementation of a network pipe
 */

#ifndef _HANDSHAKE
#define _HANDSHAKE

#include "base_object.h"
#include "synchronizeable.h"

#define _INITIAL_DATA "orxonox"
#define _INITIAL_DATA_LENGTH 7

#define _ORXONOX_VERSION "\x00\x00\x00\x01"
#define _ORXONOX_VERSION_LENGTH 4

typedef enum HandshakeState {
  HS_SENT_INIT  = 0x00000001,
  HS_RECVD_INIT = 0x00000002,
  HS_SENT_VER   = 0x00000004,
  HS_RECVD_VER  = 0x00000008,
  HS_SENT_HID   = 0x00000010,
  HS_RECVD_HID  = 0x00000020,
  HS_COMPLETED  = 0x00000040,

  HS_DO_REJECT  = 0x00010000,
  HS_WAS_REJECT = 0x00020000,

  NUM_STATES
};

class Handshake : public Synchronizeable
{
  public:
    Handshake(bool server, int clientId = 0, int networkGameManagerId = 0);
    inline bool       completed(){ return hasState( HS_COMPLETED ); }
    inline bool       ok(){ return isOk; }
    inline int        getHostId(){ return newHostId; }
    inline int        getNetworkGameManagerId(){ return newNetworkGameManagerId; }

    inline void       doReject(){ setState(HS_DO_REJECT); }

    virtual void      writeBytes(const byte* data, int length);
    virtual int       readBytes(byte* data, int maxLength, int * reciever);
    virtual void      writeDebug() const;
    virtual void      readDebug() const;

  private:
    int               state;
    int               clientId;
    int               networkGameManagerId;
    int               newHostId;
    int               newNetworkGameManagerId;
    bool              isOk;

    inline bool       hasState( int a ){ return (state & a) == a; }
    inline void       setState( int a ){ state = state | a; }
    inline void       unsetState( int a ){ state = state & (~a); }

};


#endif
