/*!
 * @file terrain.h
  *  Defines and handles the terrain of the World

    @todo implement it

    The terrain should either be build from a Model a OBJModel or from a HeightMap.
*/

#ifndef _TERRAIN_H
#define _TERRAIN_H

#include "world_entity.h"

// FORWARD DECLARATION
class SpatialSeparation;
class Material;

//! A simple method to call a desired debug world.
enum DebugTerrain {TERRAIN_DAVE, TERRAIN_BENSCH};


//! A Class to handle Terrain of orxonox
class Terrain : public WorldEntity
{

 public:
  Terrain(const TiXmlElement* root = NULL);
  Terrain(const char* fileName);
  Terrain(DebugTerrain debugTerrain);
  virtual ~Terrain();

  void init();
  void loadParams(const TiXmlElement* root);

  void loadVegetation(const char* vegetationFile);

  void buildDebugTerrain(DebugTerrain debugTerrain);
  virtual void draw() const;

  public:
    SpatialSeparation* ssp;

 private:
   Model*              vegetation;
   Material*           tmp_mat;
   int                 objectList;
};

#endif /* _TERRAIN_H */
