/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: 
*/

#include "height_map.h"
#include "model.h"
#include "texture.h"
#include "vector.h"

#include "debug.h"

// INCLUDING SDL_Image
#ifdef HAVE_SDL_IMAGE_H
#include <SDL_image.h>
#else
#include <SDL/SDL_image.h>
#endif

HeightMap::HeightMap() : StaticModel()
{
	
}

HeightMap::HeightMap(const char* height_map_name = NULL) : StaticModel()
{
   this->setClassID(CL_HEIGHT_MAP, "HeightMap");
   heightMap =  IMG_Load(height_map_name);
   if(heightMap!=NULL) {
	
		 PRINTF(0)("loading Image %s\n", height_map_name);
		 PRINTF(0)("width : %i\n", heightMap->w);
		 PRINTF(0)("hight : %i\n", heightMap->h);
		 PRINTF(0)("%i Byte(s) per Pixel \n", heightMap->format->BytesPerPixel);
		 PRINTF(0)("Rshift : %i\n", heightMap->format->Rshift);
		 PRINTF(0)("Bshift: %i\n", heightMap->format->Bshift);
		 PRINTF(0)("Gshift: %i\n", heightMap->format->Gshift);
		 PRINTF(0)("Rmask: %i\n", heightMap->format->Rmask);
		 PRINTF(0)("Gmask: %i\n", heightMap->format->Gmask);		
		}
		 
     else       PRINTF(4)("oops! couldn't load %s for some reason.\n", height_map_name);
}


HeightMap::~HeightMap()
{
	delete heightMap;
}

void HeightMap::load()
{
 unsigned char height = 0; 
 int offset = 0;

 char *  bmp = (char*) heightMap->pixels;

  if(heightMap != NULL && heightMap->format->BitsPerPixel == 8 )
	{
	SDL_LockSurface(heightMap);
	for(int i = 0 ; i < heightMap->h  ; i +=2)
	{
	    for(int j = 0; j < heightMap->w   ;  j += 2)
	    {
	    	// get local hight from heightMap
		// This seems to work only on 8-Bit Grayscale-Bitmaps
		height = bmp[j + i*(heightMap->w )];
		
			
		/*height = heightMap->format->palette->colors[offset].r +
			   heightMap->format->palette->colors[offset].g +
			   heightMap->format->palette->colors[offset].b ; */
					
				
		this->addVertex( 20*(heightMap->h - i) , (( (double)height)/0.3)-1200  ,20*j);
	     }	
	}
	SDL_UnlockSurface(heightMap);



	int c = (heightMap->w)/2 ; // One line
	for(int i = 0; i < (heightMap->w)/2  -2  ; i ++)
	{
	    for(int j = 0; j < (heightMap->h)/2 - 2; j++)
	    {
		 
		/* Two Triangles or ...*/ 
		
		//this->addFace (3, VERTEX_ONLY,j + (i+1)*c,j+1+i*c , j + i*c );
		//this->addFace (3, VERTEX_ONLY,j + (i+1)*c,j + (i+1)*c +1 ,j+i*c +1 );				
				 
		/* ... one square*/

		this->addFace (4 ,VERTEX_ONLY,j+i*c,j+(i+1)*c  ,j + (i+1)*c +1, j +i*c+1 );
	    }
				
			
				
	}
		

	}//if
  else
   	{ 

  //make a cube
  this->setName("HardCore");
  this->addVertex (-0.5, -0.5, 0.5);
  this->addVertex (0.5, -0.5, 0.5);
  this->addVertex (-0.5, 0.5, 0.5);
  this->addVertex (0.5, 0.5, 0.5);
  this->addVertex (-0.5, 0.5, -0.5);
  this->addVertex (0.5, 0.5, -0.5);
  this->addVertex (-0.5, -0.5, -0.5);
  this->addVertex (0.5, -0.5, -0.5);
	



  this->addFace (3, VERTEX_ONLY, 4, 3, 2);

	}
      this->finalize();


}
