

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PARENT_NODE

#include "null_parent.h"

using namespace std;

NullParent* NullParent::singletonRef = NULL;

/**
 *  creates the one and only NullParent
 * @param absCoordinate the cordinate of the Parent (normally Vector(0,0,0))
*/
NullParent::NullParent (const Vector& absCoordinate) : PNode (absCoordinate, NULL)
{
  this->setClassID(CL_NULL_PARENT, "NullParent");
  this->setName("NullParent");

  while (!this->getNodesChildren().empty())
    delete this->getNodesChildren().front();

  this->setParentMode(PNODE_ALL);
  NullParent::singletonRef = this;
}


/**
 *  standard deconstructor
*/
NullParent::~NullParent ()
{
  //delete singletonRef;
  NullParent::singletonRef = NULL;
}
