/*!
 * @file bv_tree.h
  *  Definition of a bounding volume tree

*/

#ifndef _BV_TREE_NODE_H
#define _BV_TREE_NODE_H

#include "base_object.h"
#include "model.h"
#include "vector.h"

// FORWARD DECLARATION
class BoundingVolume;
class BVTree;
class PNode;
class WorldEntity;
template<class T> class tList;

//! A class that represents a bounding volume tree
class BVTreeNode : public BaseObject {

 public:
  BVTreeNode();
  virtual ~BVTreeNode();

  virtual void spawnBVTree(const int depth, const sVec3D *verticesList, unsigned int length ) = 0;
  virtual void spawnBVTree(const int depth, const modelInfo& modInfo) = 0;

  virtual BoundingVolume* getBV(int index) const = 0;
  inline const int getIndex() { return this->treeIndex; }

  virtual void collideWith(BVTreeNode* treeNode, WorldEntity* nodeA, WorldEntity* nodeB) = 0;

  virtual void drawBV(int depth, int drawMode, const Vector& color = Vector(1,0,0), bool top = true) const = 0;


 private:
  unsigned int        treeIndex;                  //!< Index number of the BV in the tree

};

#endif /* _BV_TREE_NODE_H */
