/*!
 * @file vertex_array_model.h
 * @brief Contains the VertexArrayModel Class that handles 3D-Models rendered out of VertexArrays
 */

#ifndef _VERTEX_ARRAY_MODEL_H
#define _VERTEX_ARRAY_MODEL_H

#include "abstract_model.h"

#include "glincl.h"

#include "array.h"
#include <list>

/* Forward Declaration */
class Material;


/////////////
/// MODEL ///
/////////////
//! Class that handles 3D-Models. it can also read them in and display them.
class VertexArrayModel : public AbstractModel
{
 public:
  VertexArrayModel();
  virtual ~VertexArrayModel();

  void draw() const;

  void addVertex(float x, float y, float z);

  void addNormal(float x, float y, float z);

  void addTexCoor(float u, float v);

  void addIndice(GLubyte indice);

  void finalize();


  void cubeModel();

 private:
  void importToVertexArray();

 private:
  bool                       finalized;       //!< Sets the Object to be finalized.

  tArray<GLfloat>            vertices;        //!< The Array that handles the Vertices.
  tArray<GLfloat>            normals;         //!< The Array that handles the Normals.
  tArray<GLfloat>            texCoords;       //!< The Array that handles the VertexTextureCoordinates.

  tArray<GLubyte>            indices;         //!< The Array that tells us what Vertex is connected to which other one.
};

#endif
