/*!
  \file vertex_list_model.h
  \brief Contains the VertexListModel Class that handles 3D-Models rendered out of VertexArrays
*/

#ifndef _MODEL_H
#define _MODEL_H

#include "abstract_model.h"

#include "glincl.h"

#include "array.h"
#include <list>

// FORWARD DECLARATION //
template<class T> class tArray;

/////////////
/// MODEL ///
/////////////
//! Class that handles 3D-Models. it can also read them in and display them.
class Model : public AbstractModel
{
 public:
  Model();
  virtual ~Model();

  void draw() const;

  Material* addMaterial(Material* material);
  Material* addMaterial(const char* materialName);

  bool addVertex(float x, float y, float z);

  bool addVertexNormal(float x, float y, float z);

  bool addVertexTexture(float u, float v);

  bool addFace(int faceElemCount, VERTEX_FORMAT type, ...);

  bool addGroup(const char* groupString);

  bool setMaterial(Material* mtl);

  void finalize();


 private:
  bool buildTriangleList();

  bool addGLElement(ModelFaceElement* elem);

  bool importToVertexArray();

  bool deleteArrays();
  bool cleanup();

 private:
  bool                       finalized;       //!< Sets the Object to be finalized.

  tArray<GLfloat>            vertices;        //!< The Array that handles the Vertices.
  tArray<GLfloat>            normals;         //!< The Array that handles the Normals.
  tArray<GLfloat>            textures;        //!< The Array that handles the VertexTextureCoordinates.

  tArray<GLfloat>            indices;         //!< The Array that tells us what Vertex is connected to which other one.

  std::list<ModelMaterial*>  materialList;    //!< A list for all the Materials in this Model
};

#endif
