

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "npc_test.h"
#include "obb_tree.h"

#include "shader.h"
#include "state.h"
#include "list.h"
#include "stdlibincl.h"
#include "debug.h"


using namespace std;


NPC2::NPC2()
{
  this->setClassID(CL_NPC_TEST2, "NPC2");

  if ((float)rand()/RAND_MAX > .5f)
    this->loadModel("models/ships/bolido.obj", 3);
  else
    this->loadModel("models/ships/gobblin.obj", 3);

  this->shader = NULL;
  if (likely(Shader::checkShaderAbility()))
    this->shader = Shader::getShader("shaders/toon.vert", "shaders/toon.frag");

  this->obj = gluNewQuadric();

  this->randomRotAxis = VECTOR_RAND(1);
}


NPC2::~NPC2 ()
{
  if (this->shader)
    Shader::unload(this->shader);
  gluDeleteQuadric(this->obj);
}


void NPC2::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (entity->isA(CL_PROJECTILE))
  {
    PRINTF(3)("collision %s vs %s @ (%f,%f,%f)\n", this->getName(), entity->getName(), location.x, location.y, location.z);
    this->applyForce(Vector(0,0,0)-location*1000);
  }
  else if (entity->isA(CL_PLAYER))
    this->applyForce(Vector(0,0,0)-location*100);
  else
  {
    this->setVisibiliy(false);
   State::getWorldEntityList()->remove(this);
  }
}


/**
 *  the entity is drawn onto the screen with this function
 *
 * This is a central function of an entity: call it to let the entity painted to the screen.
 * Just override this function with whatever you want to be drawn.
 */
void NPC2::draw() const
{
//   glMatrixMode(GL_MODELVIEW);
//   glPushMatrix();
//   float matrix[4][4];
//
//   /* translate */
//   glTranslatef (this->getAbsCoor ().x,
//                 this->getAbsCoor ().y,
//                 this->getAbsCoor ().z);
//   /* rotate */
//   this->getAbsDir ().matrix (matrix);
//   glMultMatrixf((float*)matrix);
//
//   if (this->shader != NULL && this->shader != Shader::getActiveShader())
//     shader->activateShader();
//   gluSphere(this->obj, 3, 10, 10);
//   shader->deactivateShader();
//
//
// /*  if (this->model)
//     this->model->draw();*/
//   glPopMatrix();
}


void NPC2::tick(float dt)
{
//  Vector direction = (State::getCameraTarget()->getAbsCoor() - this->getAbsCoor());

  //if (directin.len() < 100)
//  this->shiftCoor(direction *dt * 5 * exp(-direction.len() / 30.0));
  this->shiftDir(Quaternion(dt, this->randomRotAxis));

}



