/*!
 * @file connection_monitor.h
    \brief interface for all classes that have to be synchronized
 */

#ifndef _SYNCHRONIZEABLE_H
#define _SYNCHRONIZEABLE_H

#include "base_object.h"
#include "netdefs.h"



#include <vector>
#include <list>

//State constants: They have to be of the form 2^n
#define STATE_SERVER 1
#define STATE_OUTOFSYNC 2


class Synchronizeable : virtual public BaseObject
  {
  public:

    Synchronizeable(const char* name);
    Synchronizeable();
    ~Synchronizeable();

    virtual void      writeBytes(const byte* data, int length);
    virtual int       readBytes(byte* data);
    virtual void      writeDebug() const;
    virtual void      readDebug() const;
    
    
    
    
    
    void setIsServer(bool isServer);
    void setIsOutOfSync(bool outOfSync);
    bool isServer();
    bool isOutOfSync();

  private:

    int               uniqueID;
    
    
    
    //static std::vector<Synchronizeable*> classList;
    int owner;
    int hostID;
    int state;
    std::list<int> synchronizeRequests;

  };
#endif /* _SYNCHRONIZEABLE_H */
