/*!
 * @file connection_monitor.h
    \brief interface for all classes that have to be synchronized
 */

#ifndef _SYNCHRONIZEABLE_H
#define _SYNCHRONIZEABLE_H

#include <base_object.h>
#include "netdefs.h"

class Synchronizeable : virtual public BaseObject
  {
  public:

    Synchronizeable(const char* name);
    Synchronizeable();
    ~Synchronizeable();

    virtual void      writeBytes(const byte* data, int length);
    virtual int       readBytes(byte* data);
    virtual void      writeDebug() const;
    virtual void      readDebug() const;

  private:

    int               uniqueID;

  };
#endif /* _SYNCHRONIZEABLE_H */
