/*!
 * @file server_socket.h
 *  waits for incoming connections

 */

#ifndef _SERVER_SOCKET
#define _SERVER_SOCKET

#ifdef HAVE_SDL_H
#include <SDL_thread.h>
#else
#include <SDL/SDL_thread.h>
#endif
/* include this file, it contains some default definitions */
#include "netdefs.h"


/* include base_object.h since all classes are derived from this one */
#include "base_object.h"
#include "network_socket.h"

//sleep when waiting for connections
#define _MSECONDS_SLEEP_LISTEN 100

class ServerSocket : public BaseObject
{
  private:
    TCPsocket listenSocket;
    bool terminateThread;

    bool _isListening;

    void init();

  public:
    ServerSocket();
    ServerSocket( unsigned int port );
    ~ServerSocket();
    bool listen( unsigned int port );
    NetworkSocket getNewSocket( void );
};

#endif
