/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christoph Renner
   co-programmer:
*/

/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK


/* include your own header */
#include "server_socket.h"

/* header for debug output */
#include "debug.h"

ServerSocket::ServerSocket(  )
{
  init();
}

ServerSocket::ServerSocket( unsigned int port )
{
  init();
  listen(port);
}

/**
 * Default destructor
 */
ServerSocket::~ServerSocket( )
{
  /* Quit SDL_net */
  // NOTE: what if other instances of NetworkSocket running?
  SDLNet_Quit();
  PRINTF(5)("SDL_net shutdown\n");

  _isListening = false;
}

void ServerSocket::init( )
{
  /* set the class id for the base object */
  this->setClassID(CL_SERVER_SOCKET, "ServerSocket");

  terminateThread = false;
  listenSocket = NULL;
  _isListening = false;

  if(SDLNet_Init()==-1)
  {
    PRINTF(1)("SDLNet_Init: %s\n", SDLNet_GetError());
    return;
  }
  else
    PRINTF(5)("SDL_net initialized\n");

  PRINTF(0)("ServerSocket created\n");
}


/**
 * Tells the NetworkSocket to listen on a specific port for incoming connections.
 * NetworkSocket::writeBytes(...) will have no effect until there is a valuable connection.
 * @param port
 */
bool ServerSocket::listen(unsigned int port)
{
  PRINTF(0)("ServerSocket::listen()\n");
  _isListening = true;
  //check if not already connected or listening
  if (listenSocket)
  {
    PRINTF(1)("ServerSocket::listen: tcpSocket!=NULL! maybe you already called listen or did not call close()!\n");
    _isListening = false;
    return false;
  }

  IPaddress ip;

  if (SDLNet_ResolveHost(&ip, NULL, port)==-1)
  {
    PRINTF(1)("SDLNet_ResolveHost: %s\n", SDLNet_GetError());
    _isListening = false;
    return false;
  }

  listenSocket = SDLNet_TCP_Open(&ip);

  if (!listenSocket)
  {
    PRINTF(1)("SDLNet_TCP_Open: %s\n", SDLNet_GetError());
    _isListening = false;
    return false;
  }

  return true;
}


NetworkSocket ServerSocket::getNewSocket( )
{
  TCPsocket sock = SDLNet_TCP_Accept(listenSocket);

  if ( !sock )
  {
    return NULL;
  }
  else
  {
    return NetworkSocket(sock);
  }
}

