/*!
 * @file network_stream.h
 *  implementation of a network pipe
 */

#ifndef _NETWORK_STREAM
#define _NETWORK_STREAM

#include "data_stream.h"
#include "network_protocol.h"

class Synchronizeable;
class NetworkSocket;
class ConnectionMonitor;
class NetworkProtocol;


//<! The state of the NetworkStream
typedef enum NetStat {
  NET_REC_HEADER = 0,                          //!< Waiting for header
  NET_REC_DATA,                                //!< Waiting for data

  NUM_STATES                                   //!< Number of states
};


class NetworkStream : public DataStream
{

  public:
    NetworkStream();
    NetworkStream(IPaddress& address, NodeType type);
    NetworkStream(unsigned int port, NodeType type);

    NetworkStream(IPaddress& address, Synchronizeable& sync, NodeType type);
    NetworkStream(unsigned int port, Synchronizeable& sync, NodeType type);
    ~NetworkStream();
    void init();

    void connectSynchronizeable(Synchronizeable& sync);

    inline bool isServer() const { return (this->type == NET_SERVER)? true:false; }
    inline bool isActive() const { return this->bActive; }

    virtual void processData();

  private:
    NetworkProtocol*       networkProtocol;
    ConnectionMonitor*     connectionMonitor;
    Synchronizeable*       synchronizeables;
    NetworkSocket*         networkSocket;
    int                    type;
    int                    state;
    Header                 packetHeader;
    bool                   bActive;
};
#endif /* _NETWORK_STREAM */
