/*!
 * @file network_socket.h
  *  Main interface for the network module. Manages all the modules

*/

#ifndef _NETWORK_SOCKET
#define _NETWORK_SOCKET

//if you want to use outgoing buffer define _USE_OUTGOING_BUFFER
#define _USE_OUTGOING_BUFFER

#define _INCOMING_BUFFER_SIZE 10240
#define _OUTGOING_BUFFER_SIZE 2024000
#define _LOCAL_BUFFER_SIZE 1024
//sleep if incoming buffer is full
#define _MSECONDS_SLEEP_FULL_BUFFER 10
//sleep if outgoing buffer is empty
#define _MSECONDS_SLEEP_EMPTY_BUFFER 10


/* contains memmove and memcpy */
#include <string.h>

#ifdef HAVE_SDL_H
 #include <SDL_thread.h>
#else
 #include <SDL/SDL_thread.h>
#endif
/* include this file, it contains some default definitions */
#include "netdefs.h"


/* include base_object.h since all classes are derived from this one */
#include "base_object.h"

/* using namespace std is default, this needs to be here */
using namespace std;

class NetworkSocket : public BaseObject
{

private:
//  IPaddress serverAddress;
//  unsigned int port;
  TCPsocket tcpSocket;
//  UDPsocket udpSocket;

  byte incomingBuffer[_INCOMING_BUFFER_SIZE];
#ifdef _USE_OUTGOING_BUFFER
  byte outgoingBuffer[_OUTGOING_BUFFER_SIZE];
#endif
  int incomingBufferLength;
#ifdef _USE_OUTGOING_BUFFER
  int outgoingBufferLength;
#endif

  SDL_mutex * incomingBufferMutex;
#ifdef _USE_OUTGOING_BUFFER
  SDL_mutex * outgoingBufferMutex;
#endif
  SDL_mutex * socketMutex;
  bool terminateThread;

  static int thread_read(void * data);
#ifdef _USE_OUTGOING_BUFFER
  static int thread_write(void * data);
#endif

  int writeBytes(byte * data, int length);
  int readBytes(byte * data, int length);
  int readBlock(byte * data, int length);

  void init();

public:

  NetworkSocket();
  NetworkSocket(IPaddress ip);
  NetworkSocket(TCPsocket sock);
  ~NetworkSocket();

  void connectToServer(IPaddress ip);
  void disconnectServer();

  bool writePacket(byte * data, int length);
  int readPacket(byte * data, int maxLength);

};



#endif /* _NETWORK_SOCKET */
