/*!
 * @file sound_source.h
 * @brief Definition of the SoundSource.
*/

#ifndef _SOUND_SOURCE_H
#define _SOUND_SOURCE_H

#include "base_object.h"
#include "alincl.h"

// FORWARD DECLARATION
class SoundBuffer;
class PNode;

//! A class that represents a SoundSource
class SoundSource : public BaseObject
{
  public:
    SoundSource(const PNode* sourceNode = NULL, const SoundBuffer* buffer = NULL);
    ~SoundSource();

  // user interaction
    void play();
    void play(const SoundBuffer* buffer);
    void stop();
    void pause();
    void rewind();

  // development functions
    /** @returns The ID of this Source */
    inline ALuint getID() const { return this->sourceID; }
    /** @returns true, if the Source is Playing */
    inline bool   isPlaying() const { return this->bPlay; };
    /** @returns the SoundBuffer of this Source */
    inline const SoundBuffer* getBuffer() const { return this->buffer; }
    /** @returns the SourceNode of this Source */
    inline const PNode* getNode() const { return this->sourceNode;}

    void setRolloffFactor(ALfloat rolloffFactor);

  private:
    bool                   bPlay;                 //!< If the Source is Playing.
    ALuint                 sourceID;              //!< The ID of the Source
    const SoundBuffer*     buffer;                //!< The buffer to play in this source.
    const PNode*           sourceNode;            //!< The SourceNode represente the position/velocity... of this source.
};
#endif /* _SOUND_SOURCE_H */
