/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_SOUND

#include "sound_buffer.h"

#include "sound_engine.h"

using namespace std;

//////////////////
/* SOUND-BUFFER */
//////////////////
/**
 *  Creates a Soundbuffer out of an inputfile
 * @param fileName The name of the File
 */
SoundBuffer::SoundBuffer(const char* fileName)
{
  this->setClassID(CL_SOUND_BUFFER, "SoundBuffer");
  this->setName(fileName);

  ALenum format;
  ALvoid* data;
  ALsizei freq;

  ALenum result;

  // generate a Buffer
  alGenBuffers(1, &this->bufferID);
  if ((result = alGetError()) != AL_NO_ERROR)
    PRINTF(2)("%s\n", SoundEngine::getALErrorString(result));

  // read in the wav data
  /* according to http://www.edenwaith.com/products/pige/tutorials/openal.php the alutLoadWAVFile differs from platform to platform*/
#ifdef __APPLE__
  alutLoadWAVFile((ALbyte*)fileName, &format, &data, &this->size, &freq);
#elif defined __WIN32__
  alutLoadWAVFile((ALbyte*)fileName, &format, &data, &size, &freq, &this->loop);
#else
  alutLoadWAVFile((ALbyte*)fileName, &format, &data, &this->size, &freq, &this->loop);
#endif
  if ((result = alGetError()) != AL_NO_ERROR)
    PRINTF(2)("%s\n", SoundEngine::getALErrorString(result));

  // send the loaded wav data to the buffer
  alBufferData(this->bufferID, format, data, this->size, freq);
  if ((result = alGetError()) != AL_NO_ERROR)
    PRINTF(2)("%s\n", SoundEngine::getALErrorString(result));

  // remove the wav data (redundant)
  alutUnloadWAV(format, data, this->size, freq);
  if ((result = alGetError()) != AL_NO_ERROR)
    PRINTF(2)("%s\n", SoundEngine::getALErrorString(result));
}

SoundBuffer::~SoundBuffer()
{
//  SoundEngine::getInstance()->removeBuffer(this);
  alDeleteBuffers(1, &this->bufferID);
}
