/*!
 * @file bounding_volume.h
  *  Definition of a bounding volume for collision detection algorithms

 */

#ifndef _BOUNDING_VOLUME_H
#define _BOUNDING_VOLUME_H

#include "base_object.h"
#include "abstract_model.h"


template<class T> class tList;


//! An abstract class representing a bounding volume
class BoundingVolume : public BaseObject {

  public:
    BoundingVolume();
    virtual ~BoundingVolume();

    inline const Vector& getCenter() const { return this->center; }
    inline const modelInfo* getModelInfo() const { return this->modelInf; }

    virtual void mergeWith(const BoundingVolume &bv) = 0;

    virtual void drawBV(int currentDepth, int drawMode) const = 0;



  public:
    Vector              center;                     //!< Weighter average center point of box
    Vector              arithCenter;                //!< Arithmetical center of the box

    const modelInfo*    modelInf;                   //!< Reference to the model's ModelInfo
    const int*          triangleIndexes;            //!< Array with the triangle indexes in modelInfo
    int                 triangleIndexesLength;      //!< length of the indexes array
};

#endif /* _BOUNDING_VOLUME_H */
