/*!
 * @file player.h
 * Implements a basic controllable WorldEntity
 */

#ifndef _PLAYER_H
#define _PLAYER_H

#include "world_entity.h"
#include "physics_interface.h"
#include "event_listener.h"
#include "playable.h"


//! Basic controllable WorldEntity
/**
  *  this is the debug player - actualy we would have to make a new
     class derivated from Player for each player. for now, we just use
     the player.cc for debug also
*/
class Player : public EventListener
{

  public:
    Player();
    virtual ~Player();

    void          init();


    virtual void  process(const Event &event);

    bool          setControllable(Playable* controllalble);
    void          disconnectControllable();
    Playable*     getControllable() { return this->controllable; };


  private:
    Playable*          controllable;


};

#endif /* _PLAYER_H */
