
/*!
 * @file playable.h
 * Interface for a basic controllable WorldEntity
 */
#ifndef _PLAYABLE_H
#define _PLAYABLE_H

#include "world_entity.h"
#include "event.h"
#include <list>

class Weapon;
class WeaponManager;
class Player;

//! Basic controllable WorldEntity
/**
 *
 */
class Playable : public WorldEntity
{
  public:
    Playable();
    virtual ~Playable();

    void init();

    virtual void addWeapon(Weapon* weapon )  {}//= 0;
    virtual void removeWeapon(Weapon* weapon) {}//= 0;
    inline WeaponManager* getWeaponManager() const { return this->weaponMan; };

    bool subscribePlayer(Player* player);

    virtual void process(const Event &event) {} //= 0;
    inline const std::list<int>& getEventList() { return this->events; };

  protected:
    void registerEvent(int eventType);
    void unregisterEvent(int eventType);

  private:

    WeaponManager*        weaponMan;          //!< the weapon manager: managing a list of weapon to wepaon-slot mapping
    std::list<int>        events;

    Player*               currentPlayer;

};

#endif /* _PLAYABLE_H */
