/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "turret_power_up.h"
#include "factory.h"
#include "state.h"
#include "list.h"

#include "primitive_model.h"

using namespace std;

CREATE_FACTORY(TurretPowerUp, CL_TURRET_POWER_UP);

TurretPowerUp::TurretPowerUp ()
{
  this->init();
}

TurretPowerUp::TurretPowerUp(const TiXmlElement* root)
{
  this->init();

  this->loadParams(root);
}


TurretPowerUp::~TurretPowerUp ()
{
  delete this->sphereModel;
  delete this->sphereMaterial;
}


void TurretPowerUp::init()
{
  this->setClassID(CL_TURRET_POWER_UP, "TurretPowerUp");
  this->loadModel("models/guns/turret1.obj", 2.0);

  this->sphereModel = new PrimitiveModel(PRIM_SPHERE, 7, 5);
  this->sphereMaterial = new Material;
  this->sphereMaterial->setTransparency(.1);
  this->sphereMaterial->setDiffuse(.1, .1, .8);

  this->rotation = Vector(0,1,0);
  this->cycle    = (float)rand()/RAND_MAX*M_2_PI;
  this->shiftDir(Quaternion((float)rand()/RAND_MAX*M_2_PI, this->rotation));
}


void TurretPowerUp::loadParams(const TiXmlElement* root)
{
  static_cast<PowerUp*>(this)->loadParams(root);

}


/**
 * this function is called, when two entities collide
 * @param entity: the world entity with whom it collides
 *
 * Implement behaviour like damage application or other miscellaneous collision stuff in this function
 */
void TurretPowerUp::collidesWith(WorldEntity* entity, const Vector& location)
{
 // PRINTF(3)("collision %s vs %s @ (%f,%f,%f)\n", this->getClassName(), entity->getClassName(), location.x, location.y, location.z);
 if (entity->isA(CL_PLAYABLE))
  State::getWorldEntityList()->remove(this);
}

/**
 *  this method is called every frame
 * @param time: the time in seconds that has passed since the last tick
 *
 * Handle all stuff that should update with time inside this method (movement, animation, etc.)
*/
void TurretPowerUp::tick(float dt)
{
  this->shiftDir(Quaternion(dt, this->rotation));
  this->cycle+=dt;

}

/**
 *  the entity is drawn onto the screen with this function
 *
 * This is a central function of an entity: call it to let the entity painted to the screen.
 * Just override this function with whatever you want to be drawn.
*/
void TurretPowerUp::draw() const
{  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  /* translate */
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y + cos(this->cycle*3.0)*2.0,
                this->getAbsCoor ().z);
  /* rotate */
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
  this->model->draw();

  this->sphereMaterial->select();
  this->sphereModel->draw();
  glPopMatrix();
}

