

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "environment.h"

#include "resource_manager.h"

#include "vector.h"
#include "objModel.h"
#include "obb_tree.h"
#include "factory.h"

using namespace std;
CREATE_FACTORY(Environment);

/**
 *  creates an environment
*/
Environment::Environment () : WorldEntity()
{
  this->init();
  this->loadModel("models/ships/bolido.obj");

//   if(this->obbTree == NULL)
//     this->obbTree = new OBBTree(4, (sVec3D*)this->model->getVertexArray(), this->model->getVertexCount());
}

/**
 * create an environment out of a XML-element
 * @param root the XML-element to load the Environment from
 */
Environment::Environment(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  deletes an environment
*/
Environment::~Environment ()
{}

/**
 * initialize an Environment
 */
void Environment::init()
{
  this->setClassID(CL_ENVIRONMENT, "Environment");
}

/**
 * loads the Settings of an Environment from an XML-element.
 * @param root the XML-element to load the ELements properties from
 */
void Environment::loadParams(const TiXmlElement* root)
{
  static_cast<WorldEntity*>(this)->loadParams(root);
}


/**
 *  ticks the environment
 * @param time the time about which to tick
*/
void Environment::tick (float time) {}


/**
 *  draws the Environment
*/
void Environment::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];

  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  //rotate
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);

  this->model->draw();

  glPopMatrix();
}

