/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_DETECTION

#include "obb_tree.h"
#include "obb_tree_node.h"
#include "obb.h"
#include "debug.h"
#include "compiler.h"
#include "material.h"
#include "world_entity.h"
#include "p_node.h"

using namespace std;


/**
 *  standard constructor
*/
OBBTree::OBBTree(int depth, const modelInfo& modelInf)
  : BVTree()
{
  this->depth = depth;
  this->init();
  this->spawnBVTree(modelInf);
}



void OBBTree::init()
{
  this->setClassID(CL_OBB_TREE, "OBBTree");
  this->rootNode = NULL;
  this->id = 0;
}

/**
 *  standard deconstructor

*/
OBBTree::~OBBTree ()
{
  delete this->rootNode;
}



void OBBTree::spawnBVTree(const modelInfo& modelInf)
{
  if( unlikely(this->rootNode != NULL))
  {
    PRINTF(2)("The BVTree has already been spawned, flushing and respawning again...\n");
    this->flushTree();
  }
  this->rootNode = new OBBTreeNode(*this, depth-1);

  /* triangles indexes created */
  int* triangleIndexes = new int[modelInf.numTriangles];
  for(int i = 0; i < modelInf.numTriangles; ++i)
    triangleIndexes[i] = i;

  this->rootNode->spawnBVTree(modelInf, triangleIndexes, modelInf.numTriangles);
}




void OBBTree:: flushTree()
{}


/**
 * this collides two bvtrees together. the trees are attached to pnodes Objects A and B
 * @param nodeA: PNode of object A
 * @param nodeB: Pnode of object B
 */
void OBBTree::collideWith(const WorldEntity& entity1, const WorldEntity& entity2) const
{
  if( likely(entity2.getOBBTree() != NULL) )
    this->rootNode->collideWith(*(((OBBTree*)entity2.getOBBTree())->getRootNode()), entity1, entity2);
}



void OBBTree::drawBV(int depth, int drawMode) const
{
  if( likely(this->rootNode != NULL))
  {
    this->rootNode->drawBV(depth, drawMode);
  }
}



void OBBTree::debug()
{
  PRINT(0)("\n==============================| OBBTree::debug() |===\n");
  PRINT(0)("=  Spawning Tree: Start\n");

  /* generate some test vertices */
  int const length = 9;
  sVec3D* vertList = new sVec3D[length];
//   sVec3D data[length]  = {{0.0, 0.0, 0.0},{1.0, 2.0, 5.0},{0.0, 6.0, 9.0},
//                           {1.0, 4.0, 12.0}, {1.0, 2.0, 16.0}, {0.0, 0.0, 19.0},
//                           {0.0, 3.0, 23.0}, {1.0, 5.0, 30.0}, {0.0, 10.0, 35.0}};

  sVec3D data[length]  = {{0.0, 0.0, 0.0},{1.0, 2.0, 5.0},{1.0, 5.0, 30.0},
                          {0.0, 3.0, 23.0}, {0.0, 6.0, 9.0}, {0.0, 10.0, 35.0},
                          {1.0, 4.0, 12.0}, {1.0, 2.0, 16.0}, {0.0, 0.0, 19.0}};

  for(int i = 0; i < length; ++i)
    {
      vertList[i][0] = data[i][0];
      vertList[i][1] = data[i][1];
      vertList[i][2] = data[i][2];
    }

//   this->spawnBVTree(vertList, length);

  PRINT(0)("=  Spawning Tree: Finished\n");
  PRINT(0)("=======================================================\n");

}
