/*!
 * @file bv_tree.h
  *  Definition of a bounding volume tree

*/

#ifndef _BV_TREE_NODE_H
#define _BV_TREE_NODE_H


#include "base_object.h"
#include "abstract_model.h"
#include "vector.h"


// forward declarations
class BoundingVolume;
class BVTree;
class PNode;
class WorldEntity;
template<class T> class tList;


//! A class that represents a bounding volume tree
class BVTreeNode : public BaseObject {


 public:
  BVTreeNode();
  virtual ~BVTreeNode();

  virtual const BoundingVolume* getBV() const = 0;
  /** returns the index of this bounding volume tree node @returns index of this index */
  inline const int getIndex() const { return this->treeIndex; }

  virtual void spawnBVTree(const modelInfo& modInfo, const int* triangleIndexes, unsigned int length) = 0;
  virtual void collideWith(const BVTreeNode& treeNode, const WorldEntity& nodeA, const WorldEntity& nodeB) const = 0;
  virtual void drawBV(int depth, int drawMode, const Vector& color = Vector(1,0,0), bool top = true) const = 0;


 private:
  unsigned int        treeIndex;                  //!< Index number of the BV in the tree

};

#endif /* _BV_TREE_NODE_H */
