/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Knecht
*/

#include "weapons/weapon_manager.h"

#include "playable.h"
#include "event_handler.h"
#include "player.h"


Playable::Playable()
{
  this->init();
}

Playable::~Playable()
{
  delete this->weaponMan;
}

void Playable::init()
{
  this->setClassID(CL_PLAYABLE, "Playable");
  PRINTF(4)("PLAYABLE INIT\n");
  this->weaponMan = new WeaponManager(this);
}

/**
 * subscribe to all events the controllable needs
 */
void Playable::subscribeEvents(Player* player)
{
  /*EventHandler*/
  EventHandler* evh = EventHandler::getInstance();
  std::list<int>::iterator ev;
  for (ev = this->events.begin(); ev != events.end(); ev++)
  {
    evh->subscribe(player, ES_GAME, (*ev));
  }

}
