/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...

   this file extends the framework file, so it renders what i want.
*/

#include "framework.h"

#include "light.h"

#include "texture_sequence.h"
#include "material.h"

#include "objModel.h"

#include "primitive_model.h"
#include <stdlib.h>

#include "resource_manager.h"

Model* obj;
TextureSequence* seq;
Texture* test;
float counter = 0;

void Framework::moduleInit(int argc, char** argv)
{
  ResourceManager::getInstance()->addImageDir("./");

  seq = new TextureSequence();
  for (int i = 1; i < argc; i++)
  {
    seq->addFrame(argv[i]);
    printf("%s\n", argv[i]);
  }
  test = new Texture(argv[1]);

  ResourceManager::getInstance()->addImageDir("");


  obj = new PrimitiveModel(PRIM_CYLINDER);

  ResourceManager::getInstance()->debug();

  LightManager* lightMan = LightManager::getInstance();
  lightMan->setAmbientColor(.1,.1,.1);
  (new Light())->setAbsCoor(5.0, 10.0, 40.0);
  (new Light())->setAbsCoor(-10, -20, -100);
}

void Framework::moduleEventHandler(SDL_Event* event)
{
  switch (event->type)
    {
    case SDL_KEYDOWN:
      switch (event->key.keysym.sym)
        {
        case SDLK_i:
          break;
        }
    }
}

void Framework::moduleTick(float dt)
{
  counter+=dt;

  seq->gotoFrame((unsigned int)counter);
  if ((unsigned int)counter > seq->getFrameCount())
    counter = 0;
}

void Framework::moduleDraw(void) const
{
  float diffuse[] = {1,1,1,1};
  float ambient[] = {1,0,0,1};
  float specular[] = {1,0,1,1};
  // setting diffuse color
  //  glColor3f (diffuse[0], diffuse[1], diffuse[2]);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuse);

  // setting ambient color
  glMaterialfv(GL_FRONT, GL_AMBIENT, ambient);

  // setting up Sprecular
  glMaterialfv(GL_FRONT, GL_SPECULAR, specular);

  // setting up Shininess
  glMaterialf(GL_FRONT, GL_SHININESS, .4);
  glShadeModel(GL_SMOOTH);

  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, seq->getTexture());
//  printf("Number = %d\n", seq->getTexture());
    /* This allows alpha blending of 2D textures with the scene */
//     if (seq->hasAlpha())
//     {
//       glEnable(GL_BLEND);
//       glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
//     }

  obj->draw();

  LightManager::getInstance()->draw();
}


void Framework::moduleHelp(void) const
{

}
