/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_IMPORTER

#include "texture_sequence.h"

#include "debug.h"
#include "graphics_engine.h"

#include <stdarg.h>

#ifdef HAVE_SDL_IMAGE_H
#include <SDL_image.h>
#else
#include <SDL/SDL_image.h>
#endif

/**
 *  Constructor for a Texture
*/
TextureSequence::TextureSequence(unsigned int count, ...)
{
  this->setClassID(CL_TEXTURE_SEQUENCE, "TextureSequence");

  va_list textureNameList;
  va_start(textureNameList, count);

  this->loadImageSeries(count, textureNameList);
}

/**
 *  Destructor of a TextureSequence

   Frees Data, and deletes the textures from GL
*/
TextureSequence::~TextureSequence()
{
}


/**
 * rebuilds all the textures from the Images stored in this FrameSequence
 */
bool TextureSequence::rebuild()
{
//   if (this->texture != 0 && glIsTextureSequence(this->texture))
//     {
//       glDeleteTextureSequences(1,&this->texture);
//       this->texture = 0;
//     }
//
//   if (this->image != NULL)
//     {
//       PRINTF(3)("Reloading TextureSequence of %s '%s'\n", this->getClassName(), this->getName());
//       this->texture = loadTexToGL(this->image);
//     }

}



bool TextureSequence::loadImageSeries(unsigned int count, ...)
{
  va_list textureNameList;
  va_start(textureNameList, count);

  this->loadImageSeries(count, textureNameList);
}

bool TextureSequence::loadImageSeries(unsigned int count, va_list textures)
{


}


bool TextureSequence::addFrame(const char* imageName)
{


}


bool TextureSequence::addFrame(SDL_Surface* surface)
{


}


