/*!
 * @file texture.h
 * @brief Contains the texture class, that handles the reading of Images into Texutre-files.
 */

#ifndef _MULTI_FRAME_TEXTURE_H
#define _MULTI_FRAME_TEXTURE_H

#include "texture.h"

#include "glincl.h"
#include <vector>

/* Forward Declaration */
struct SDL_Surface;

//! A Class, that reads in Textures from different fileformats.
  class MultiFrameTexture : public Texture
  {
    public:
      MultiFrameTexture(unsigned int count, ...);
  //  Texture(TEXTURE_TYPE type, int resolution);
      ~MultiFrameTexture();

      bool loadImages(unsigned int cound, ...);
      bool rebuild();

      /** @returns The textureID of this texture.  */
      inline GLuint getFrameTexture(unsigned int frameNumber) const { return this->textures[frameNumber]; };

      const SDL_Surface* const getFrameImage(unsigned int frameNumber) const { return this->images[frameNumber]; };

    private:
      std::vector<GLuint>          textures;            //!< The Texture-ID of opengl from this Texture.
      std::vector<SDL_Surface*>    images;              //!< The SDL_Surfce that stores the Texture on it.
  };

#endif /* _MULTI_FRAME_TEXTURE_H */
