
/*!
 * @file playable.h
 * Interface for a basic controllable WorldEntity
 */
#ifndef _PLAYABLE_H
#define _PLAYABLE_H

#include "world_entity.h"
#include "event.h"
#include <list.h>

class Weapon;
class WeaponManager;

//! Basic controllable WorldEntity
/**
 *  this is the debug player - actualy we would have to make a new
     class derivated from Player for each player. for now, we just use
     the player.cc for debug also
 */
class Playable : public WorldEntity
{

  public:
    Playable();
    virtual ~Playable();

    void init();
    void loadParams(const TiXmlElement* root);

    virtual void addWeapon(Weapon* weapon )= 0;
    virtual void removeWeapon(Weapon* weapon) = 0;

    virtual void process(const Event &event) = 0;
    virtual void setKeySet();
    virtual void getKeySet();
    std::list<Event*> getEventList();
    WeaponManager* getWeaponManager();

  private:

    WeaponManager*        weaponMan;          //!< the weapon manager: managing a list of weapon to wepaon-slot mapping
    std::list<Event*>*     events;


};

#endif /* _PLAYABLE_H */
