/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Knecht
*/

#include "player.h"

#include "factory.h"

#include "list.h"

#include "event_handler.h"

#include "event.h"

using namespace std;

CREATE_FACTORY(Player, CL_PLAYER);

/**
 * creates a new Player
*/
Player::Player()
{
  this->init();
}


/**
 *  destructs the player, deletes alocated memory
 */
Player::~Player ()
{
}


/**
 * initializes a Player
 */
void Player::init()
{
//  this->setRelDir(Quaternion(M_PI, Vector(1,0,0)));
  this->setClassID(CL_PLAYER, "Player");

  PRINTF(4)("PLAYER INIT\n");

}

/**
 * subscribe to all events because the player dosen't know to witch keys the controllable can react
 */
void Player::subscribeEvents()
{
  EventHandler* evh = EventHandler::getInstance();
  for (int i = 1; i < SDLK_LAST; i++)
   {
     if (!evh->isSubscribed(ES_GAME, i))
          evh->subscribe(this, ES_GAME, i);
   }

}

void Player::process(const Event &event)
{
  this->controllable->process(event);
}


void Player::setControllable(Playable controllalble)
 {
   this->controllable = controllable;
 }



Playable* Player::getControllable()
{
  return controllable;
}

