/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...

   this file extends the framework file, so it renders what i want.
*/

#include "framework.h"

#include "fields.h"
#include "stdlibincl.h"
#include "light.h"

#include "cd_engine.h"
#include "bv_tree.h"

#include "md2Model.h"
#include "model.h"
#include "collision_test_entity.h"


#include "graphics_engine.h"
#include "list.h"


Model* mod;
MD2Model* model;
int drawMode;
int depth;
float iterata;
tList<WorldEntity>* entityList;

int lastFrame, currentFrame, dt;
bool drawModel = false;

WorldEntity* a;
WorldEntity* b;
//Terrain* c;
bool animateModel = false;

void Framework::moduleInit(int argc, char** argv)
{
  GraphicsEngine::getInstance()->setWindowName("Collision Cluster", "collision");

  CDEngine::getInstance();

  /* Primitive Data Test */
//   sVec3D* data = new sVec3D[6];
//   float tmp[6][3] = {{0.0, 4.2, 2.4}, {3.0, 3.0, 2.0}, {5.0, 1.0, 6.0}, {6.5, 1.0, 3.0}, {7.0, 3.0, 5.0}, {8.0, 6.0, 6.0}};
//   for(int i = 0; i < 6; ++i)
//   {
//     data[i][0] = tmp[i][0];
//     data[i][1] = tmp[i][1];
//     data[i][2] = tmp[i][2];
//   }
//   CDEngine::getInstance()->debugSpawnTree(5, data, 6);

  /* MD2 Model Test */
//   model = new MD2Model("models/tris.md2", "models/tris.pcx");
//   model->tick(0.1f);
//   CDEngine::getInstance()->debugSpawnTree(9, model->data->pVertices, model->data->numVertices);

  /* OBJ - Model Test */
//   mod = (Model*)ResourceManager::getInstance()->load("models/reaplow.obj", OBJ, RP_CAMPAIGN);
//   CDEngine::getInstance()->debugSpawnTree(9, (sVec3D*)mod->getVertexArray(), mod->getVertexArrayCount());



  entityList = new tList<WorldEntity>();

//   a = new TestEntity(); a->setName("Clown1");
   b = new CollisionTestEntity(); b->setName("Jaeger");
   if (argc > 1)
   {
     printf("Loading model %s\n", argv[1]);
     b->loadModel(argv[1]);
   }
//   a = new Terrain();

//   b->setRelCoor(0.0, 0.0, -20.0);
//   b->setRelDir(Quaternion(-M_PI/2.0f, Vector(0.0, 1.0, 0.0)));

  entityList->add(b);
//   entityList->add(b);

  CDEngine::getInstance()->setEntityList(entityList);

  LightManager* lightMan = LightManager::getInstance();
  lightMan->setAmbientColor(.1,.1,.1);
  (new Light())->setAbsCoor(-5.0, 50.0, -40.0);
  (new Light())->setAbsCoor(100, 80, 60);


  /* properties */
  drawMode = DRAW_MODEL;
  depth = 0;
  dt = lastFrame = currentFrame = 0;
  iterata = 0.05f;

  moduleHelp();
}


void Framework::moduleEventHandler(SDL_Event* event)
{
  switch (event->type)
  {
    case SDL_KEYDOWN:
      switch (event->key.keysym.sym)
      {
        case SDLK_a:
          drawMode |= DRAW_ALL;
          break;
        case SDLK_0:
        {
          printf("Setting tree depth = 0\n");
          depth = 0;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_1:
        {
          printf("Setting tree depth = 1\n");
          depth = 1;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_2:
        {
          printf("Setting tree depth = 2\n");
          depth = 2;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_3:
        {
          printf("Setting tree depth = 3\n");
          depth = 3;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_4:
        {
          printf("Setting tree depth = 4\n");
          depth = 4;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_5:
        {
          printf("Setting tree depth = 5\n");
          depth = 5;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_6:
        {
          printf("Setting tree depth = 6\n");
          depth = 6;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_s:
          if(drawMode & DRAW_SEPARATING_PLANE)
          {
            int temp = drawMode & DRAW_SEPARATING_PLANE;
            drawMode ^= temp;
            printf("Removing Separation Plane\n");
          }
          else
          {
            drawMode |= DRAW_SEPARATING_PLANE;
            printf("Drawing Separation Plane\n");
          }

          break;
        case SDLK_p:
          if(drawMode & DRAW_BV_POLYGON)
          {
            int temp = drawMode & DRAW_BV_POLYGON;
            drawMode ^= temp;
            printf("Removing OBB Polygons\n");
          }
          else
          {
            drawMode |= DRAW_BV_POLYGON;
            printf("Drawing OBB Polygons\n");
          }
          break;
        case SDLK_o:
          if(iterata == 0.0f)
          {
            iterata = 0.05f;
          }
          else
          {
            iterata = 0.0f;
          }
          break;

      }
  }
}


void Framework::moduleTick(float dt)
{

  CDEngine::getInstance()->checkCollisions();


 // b->shiftCoor(Vector(0.0, 0.0, iterata * dt * 12.0f));


  tIterator<WorldEntity>* iterator = entityList->getIterator();
  WorldEntity* entity = iterator->firstElement();
  while( entity != NULL)
  {
    if( unlikely(animateModel))
      entity->tick(dt);
    entity = iterator->nextElement();
  }
  delete iterator;
}


void Framework::moduleDraw() const
{
  //CDEngine::getInstance()->debugDraw(depth, drawMode);

  tIterator<WorldEntity>* iterator = entityList->getIterator();
  WorldEntity* entity = iterator->firstElement();
  while( entity != NULL)
  {
    if( likely(drawModel))
      entity->draw();
    entity->drawBVTree(depth, drawMode);
    printf("%i, %i\n", depth, drawMode);
    entity = iterator->nextElement();
  }
  delete iterator;

  LightManager::getInstance()->draw();
}


void Framework::moduleHelp(void) const
{
  printf("\n\n===========================");
  printf("Collision Detection Modler:\n");
  printf("Key Bindings:\n");
  printf(" -| Displaying Polygons\t\t p\n");
  printf(" -| Displaying Separation Plane\t s\n");
  printf("\n");
  printf(" -| Tree Depth 0\t\t 0\n");
  printf(" -| Tree Depth 1\t\t 1\n");
  printf(" -| Tree Depth 2\t\t 2\n");
  printf(" -| Tree Depth 3\t\t 3\n");
  printf(" -| Tree Depth 4\t\t 4\n");
  printf(" -| Tree Depth 5\t\t 5\n");
  printf("===========================\n\n");

}

int boxPolygons(GtkWidget* nonInterest, void* widget)
{
  if(drawMode & DRAW_BV_POLYGON)
  {
    int temp = drawMode & DRAW_BV_POLYGON;
    drawMode ^= temp;
    printf("Removing OBB Polygons\n");
  }
  else
  {
    drawMode |= DRAW_BV_POLYGON;
    printf("Drawing OBB Polygons\n");
  }
}

int seperatingPlanes(GtkWidget* nonInterest, void* widget)
{
  if(drawMode & DRAW_SEPARATING_PLANE)
  {
    int temp = drawMode & DRAW_SEPARATING_PLANE;
    drawMode ^= temp;
    printf("Removing Separation Plane\n");
  }
  else
  {
    drawMode |= DRAW_SEPARATING_PLANE;
    printf("Drawing Separation Plane\n");
  }
}


int blendedBox(GtkWidget* nonInterest, void* widget)
{
  if(drawMode & DRAW_BV_BLENDED)
  {
    int temp = drawMode & DRAW_BV_BLENDED;
    drawMode ^= temp;
    printf("Removing OBB Polygons\n");
  }
  else
  {
    drawMode |= DRAW_BV_BLENDED;
    printf("Drawing OBB Polygons\n");
  }
}


int drawModels(GtkWidget* nonInterest, void* widget)
{
  drawModel = !drawModel;
}


int animateModels(GtkWidget* nonInterest, void* widget)
{
  animateModel = !animateModel;
}


int drawPoints(GtkWidget* nonInterest, void* widget)
{
  if(drawMode & DRAW_POINTS)
  {
    int temp = drawMode & DRAW_POINTS;
    drawMode ^= temp;

  }
  else
  {
    drawMode |= DRAW_POINTS;
    printf("Drawing OBB Polygons\n");
  }
}


int treeDepth(GtkWidget* nonInterest, void* widget)
{
  Option* option = (Option*) widget;
  const char* name = option->getTitle();
  char* value = option->save();

  depth = atoi(value);
  printf("Setting tree depth = %i\n", depth);
  int temp = drawMode & DRAW_ALL;
  drawMode ^= temp;
  drawMode |= DRAW_SINGLE;

  delete value;
}


void Framework::moduleInitGui(int argc, char** argv)
{
  Window* guiMainWindow = NULL;

  initGUI(0, NULL);

  guiMainWindow = new Window("Collision_detection");
  {
    Box* windowBox = new Box('v');
    {
      CheckButton* BoxPolygons = new CheckButton("Draw OBB Polygons");
      BoxPolygons->connectSignal("clicked", (void*)BoxPolygons, boxPolygons);
      windowBox->fill(BoxPolygons);


      CheckButton* BlendedBox = new CheckButton("Draw OBB Blended");
      BlendedBox->connectSignal("clicked", (void*)BlendedBox, blendedBox);
      windowBox->fill(BlendedBox);


      CheckButton* DrawModels = new CheckButton("Draw Models");
      DrawModels->connectSignal("clicked", (void*)DrawModels, drawModels);
      windowBox->fill(DrawModels);



      CheckButton* AnimateModels = new CheckButton("Animate Models");
      AnimateModels->connectSignal("clicked", (void*)AnimateModels, animateModels);
      windowBox->fill(AnimateModels);


      CheckButton* DrawPoints = new CheckButton("Draw Points");
      DrawPoints->connectSignal("clicked", (void*)DrawPoints, drawPoints);
      windowBox->fill(DrawPoints);


      CheckButton* SeperatingPlanes = new CheckButton("SeperatingPlanes");
      SeperatingPlanes->connectSignal("clicked", (void*)SeperatingPlanes, seperatingPlanes);
      windowBox->fill(SeperatingPlanes);


      Slider* TreeDepth = new Slider("TreeDepth", 0, 17);
      TreeDepth->connectSignal("value_changed", (void*)TreeDepth, treeDepth);
      windowBox->fill(TreeDepth);
    }
    guiMainWindow->fill(windowBox);
  }
  Window::mainWindow->showall();
  Window::mainWindow->setSize(300, 500);
}
